import 'package:flutter/material.dart';
import 'package:six_pos/helper/extension_helper.dart';
import 'package:six_pos/util/dimensions.dart';
import 'package:six_pos/util/styles.dart';

class InvoiceElementWidget extends StatelessWidget {
  final bool isBold;
  final String? title;
  final String? serial;
  final String? quantity;
  final String? price;
  const InvoiceElementWidget({
    super.key,
    this.serial,
    this.isBold = false,
    this.title,
    this.quantity,
    this.price,
  });

  @override
  Widget build(BuildContext context) {
    return  Row(children: [
      Expanded(flex: 5,
        child: serial != null ?
        Row(mainAxisAlignment: MainAxisAlignment.start,children: [
          _textView(context, serial!, false),
          const SizedBox(width: Dimensions.paddingSizeDefault),

          _textView(context, title!, false),
        ]) :
        _textView(context, title!, false),
      ),

      Expanded(flex: 3,
        child: Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
          quantity != null ? _textView(context, quantity!, false) : const SizedBox(),
          const SizedBox(width: Dimensions.paddingSizeDefault),

          _textView(context, price!, true)
        ]),
      ),
    ]);
  }

  Text _textView(BuildContext context,String text, bool isBold) {
    return Text(
      text,
      style: isBold ?
      ubuntuRegular.copyWith(
      color: context.customThemeColors.textColor,
      fontSize: Dimensions.fontSizeLarge,
      ) :
      ubuntuRegular.copyWith(color: context.customThemeColors.textOpacityColor),
    );
  }
}
